<?php
namespace App\Exports;

use App\Models\Database;
use App\Models\City;
use App\Models\Category;
use App\Models\Subcategory;
use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\ShouldAutoSize;
use Maatwebsite\Excel\Concerns\WithMapping;
use Illuminate\Support\Facades\Auth;
class DatabaseExport implements FromCollection, WithHeadings, ShouldAutoSize, WithMapping
{
    protected $request;

    public function __construct($request)
    {
        $this->request = $request;
    }

    public function collection()
    {
        $request = $this->request;
        $startDate = $request->startDate?date('Y-m-d', strtotime($request->startDate)):'';
        $endDate = $request->endDate?date('Y-m-d', strtotime($request->endDate)):'';
        $records = Database::orderBy('id','DESC')->with(['employee']);
                // if(Auth::guard('admin')->user()->role_id != 1){
                //     $records->where('employee_id',Auth::guard('admin')->user()->id);
                // }
                if($request->city){
                    $records->whereRaw("FIND_IN_SET(?, city)", [$request->city]);
                } 
                if($request->sub_category){
                    $records->whereRaw("FIND_IN_SET(?, sub_category)", [$request->sub_category]);
                }
                if($request->employee){
                    $records->where('employee_id',$request->employee);
                }
                if($startDate){
                    if($endDate){
                        $records->whereDate('created_at','>=',$startDate);
                    }else{
                        $records->whereDate('created_at','=',$startDate);
                    }
                }
                if($endDate){
                    $records->whereDate('created_at','<=',$endDate);
                }
        return $records->get();
    }

    public function headings(): array
    {
        return ['Name','City', 'Mobile Number', 'Email', 'Category', 'Sub Category', 'Employee','Created At','Updated At','Status'];
    }

    public function map($value): array
    {
        $city_id = $value->city ? explode(',', $value->city) : [];
        $category_id = $value->category_id ? explode(',', $value->category_id) : [];
        $sub_category = $value->sub_category ? explode(',', $value->sub_category) : [];
        $city_name = City::whereIn('id', $city_id)->pluck('name')->implode(', ');
        $category_name = Category::whereIn('id', $category_id)->pluck('name')->implode(', ');
        $sub_category_name = Subcategory::whereIn('id', $sub_category)->pluck('name')->implode(', ');
        return [
                $value->name??'-',
                $city_name??'-',
                $value->mobile_number??'-',
                $value->email??'-',
                $category_name??'-',
                $sub_category_name??'-',
                $value->employee->name??'-',
                $value->status??'-',
                $value->created_at?date('d-m-Y', strtotime($value->created_at)):'-',
                $value->updated_at?date('d-m-Y', strtotime($value->updated_at)):'-',
        ];
    }
}