<?php
namespace App\Exports;

use App\Models\Campaign;
use App\Models\CampaignDetail;
use App\Models\Member;
use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\ShouldAutoSize;
use Maatwebsite\Excel\Concerns\WithMapping;
use Illuminate\Support\Facades\Auth;
use Carbon\Carbon;

class CommissionReportExportAdmin implements FromCollection, WithHeadings, ShouldAutoSize, WithMapping
{
    protected $request;

    public function __construct($request)
    {
        $this->request = $request;
    }

    public function collection()
    {
        $admin = Auth::guard('admin')->user();

        $all_agency_ids = Member::query()->where('business_type', 'Marketing Agency')
            ->when($admin->role_id != 1, function ($query) use ($admin) {
                $query->where('admin_referred_id', $admin->id);
            })->pluck('id')->unique()->toArray();

        $records = Campaign::whereIn('member_id', $all_agency_ids)->with(['member'])->orderBy('id', 'DESC');

        if (!empty($this->request->start_date) && !empty($this->request->end_date)) {
            $start = Carbon::createFromFormat('m-Y', $this->request->start_date)->startOfMonth();
            $end   = Carbon::createFromFormat('m-Y', $this->request->end_date)->endOfMonth();
            $records->whereBetween('created_at', [$start, $end]);
        }

        /* if (!empty($this->request->search) && is_array($this->request->search)) {
            $search = $this->request->search['value'] ?? '';
            if (!empty($search)) {
                $records->where(function ($q) use ($search) {
                    $q->where('campaigns.campaign_name', 'like', "%{$search}%")
                      ->orWhereHas('member', function ($q2) use ($search) {
                          $q2->where('businessName', 'like', "%{$search}%");
                      })
                      ->orWhereHas('member.city', function ($q3) use ($search) {
                          $q3->where('name', 'like', "%{$search}%");
                      });
                });
            }
        } */

        return $records->get();
    }

    public function headings(): array
    {
        return [ 'SL No', 'Date', 'Campaign Name', 'Business Name', 'City', 'Email', 'Commission', 'Payment Status', 'Note' ];
    }

    public function map($value): array
    {
        $commission = CampaignDetail::where('campaign_id', $value->id)->sum('commission_total');
        return [
            $value->id,
            $value->created_at ? date('d-m-Y', strtotime($value->created_at)) : '-',
            $value->campaign_name ?? '-',
            $value->member->businessName ?? '-',
            $value->member->city->name ?? '-',
            $value->member->email ?? '-',
            round($commission / 100, 2),
            'Pending',
            $value->note ?? '-',
        ];
    }

}
