<?php
namespace App\Exports;

use App\Models\Campaign;
use App\Models\CampaignDetail;
use App\Models\Ledger;
use App\Models\Member;
use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\ShouldAutoSize;
use Maatwebsite\Excel\Concerns\WithMapping;
use Illuminate\Support\Facades\Auth;
use Carbon\Carbon;

class CommisonReport implements FromCollection, WithHeadings, ShouldAutoSize, WithMapping
{
    protected $request;

    public function __construct($request)
    {
        $this->request = $request;
    }

    public function collection()
    {
        $member = Member::where('member_referred_id', Auth::guard('member')->user()->id)->pluck('id')->implode(',');
        $records = Campaign::whereIn('member_id', explode(',', $member))->with(['member'])->orderBy('id','DESC');
        if (!empty($this->request->start_date) && !empty($this->request->end_date)) {
            $start = Carbon::createFromFormat('m/Y', $this->request->start_date)->startOfMonth();
            $end   = Carbon::createFromFormat('m/Y', $this->request->end_date)->endOfMonth();

            $records->whereBetween('created_at', [$start, $end]);
        }
        return $records->get();
    }

    public function headings(): array
    {
        return ['SL No', 'Date','Business Name','City','Email','Campaign Name','Commission','Payment Status', 'Note'];
    }

    public function map($value): array
    {
        $commission = CampaignDetail::where('campaign_id',$value->id)->sum('commission_total');
        return [
                $value->id,
                $value->created_at?date('d-m-Y', strtotime($value->created_at)):'-',
                $value->member->businessName??'-',
                $value->member->city->name??'-',
                $value->member->email??'-',
                $value->campaign_name??'-',
                round($commission/100,2),
                'Pending',
                $value->note??'-',
        ];
    }
}