<?php
namespace App\Exports;

use App\Models\CampaignDetail;
use App\Models\City;
use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\ShouldAutoSize;
use Maatwebsite\Excel\Concerns\WithMapping;

class CampaignReportExport implements FromCollection, WithHeadings, ShouldAutoSize, WithMapping
{
    protected $request;
    protected $id;

    public function __construct($request, $id)
    {
        $this->request = $request;
        $this->id = $id;
    }

    public function collection()
    {
        $query = CampaignDetail::with(['database', 'member'])->where('campaign_id', $this->id);

        $search = $this->request->input('search');
        if ($search) {
            $query->where(function($q) use($search){
                $q->where('status', 'like', "%$search%")
                  ->orWhere(fn($q2) => $q2->where('status','Interested')->where('database_number','like',"%$search%"))
                  ->orWhereHas('database', function($q3) use($search) {
                      $q3->where('name','like',"%$search%");
                  });
            });
        }

        if ($status = $this->request->input('status')) {
            $query->whereRaw('LOWER(status) = ?', [strtolower($status)]);
        }


        if ($call_status = $this->request->input('call_status')) {
            $query->whereRaw('LOWER(call_status) = ?', [strtolower($call_status)]);
        }

        if ($startTime = $this->request->input('startTime')) {
            $query->where('start_time', '>=', date('Y-m-d H:i:s', strtotime($startTime)));
        }

        if ($endTime = $this->request->input('endTime')) {
            $query->where('end_time', '<=', date('Y-m-d H:i:s', strtotime($endTime)));
        }

        return $query->get();
    }


    public function headings(): array
    {
        return ['Business Name','City','Number','Sell Price','Call Date','Start Time','End Time','Call Duration','Record','Status','Call Status'];
    }

    public function map($record): array
    {
        $city_name = $record->database && $record->database->city ? City::whereIn('id', explode(',', $record->database->city))->pluck('name')->implode(', ') : '-';
        $database_number = $record->status === 'Interested' ? $record->database_number : maskMobile($record->database_number);

        return [
            $record->database->name ?? '-',
            $city_name,
            $database_number,
            $record->sell_price ?? '-',
            $record->call_date ? date('d-m-Y', strtotime($record->call_date)) : '-',
            $record->start_time ? date('d-m-Y h:i:s A', strtotime($record->start_time)) : '-',
            $record->end_time ? date('d-m-Y h:i:s A', strtotime($record->end_time)) : '-',
            $record->call_duration ? secendConvertMin($record->call_duration) : '',
            $record->voice_record_url ?? '-',
            $record->status ?? '-',
            $record->call_status ?? '-'
        ];
    }

}
