<?php
namespace App\Exports;

use App\Models\BillPayment;
use App\Models\Member;
use App\Models\Category;
use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\ShouldAutoSize;
use Maatwebsite\Excel\Concerns\WithMapping;
use Illuminate\Support\Facades\Auth;
use Carbon\Carbon;

class BillPaymentExport implements FromCollection, WithHeadings, ShouldAutoSize, WithMapping
{
    protected $request;

    public function __construct($request)
    {
        $this->request = $request;
    }

    public function collection()
    {
        $request = $this->request;
        $records = BillPayment::query();
        if($request->member_id){
            $records->where('member_id', $request->member_id);
        }
        if ($request->startDate && $request->endDate) {
            $records->whereBetween('created_at', [
                Carbon::createFromFormat('d-m-Y', $request->startDate)->startOfDay(),
                Carbon::createFromFormat('d-m-Y', $request->endDate)->endOfDay()
            ]);
        } elseif ($request->startDate) {
            $records->where('created_at', '>=', Carbon::createFromFormat('d-m-Y', $request->startDate)->startOfDay());
        } elseif ($request->endDate) {
            $records->where('created_at', '<=', Carbon::createFromFormat('d-m-Y', $request->endDate)->endOfDay());
        }
        return $records->get();
    }

    public function headings(): array
    {
        return ['Invoice Number','Member ID','Business Name','Mobile No','City','Email','Category','Date&Time','Total Amount','Created At','Updated At'];
    }

    public function map($value): array
    {
        return [
            $value->invoice_number??'-',
            $value->member_id??'-',
            $value->member->businessName??'-',
            $value->member->mobile??'-',
            $value->member->city->name??'-',
            $value->member->email??'-',
            Category::whereIn('id',explode(',', $value->member->category_id))->pluck('name')->implode(', ')??'-',
            $value->created_at?date('d-m-Y', strtotime($value->created_at)):'-',
            $value->total_amount??'-',
            $value->created_at?date('d-m-Y', strtotime($value->created_at)):'-',
            $value->updated_at?date('d-m-Y', strtotime($value->updated_at)):'-'
        ];
    }

}