<?php
namespace App\Exports;

use App\Models\Ledger;
use App\Models\Member;
use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\ShouldAutoSize;
use Maatwebsite\Excel\Concerns\WithMapping;
use Illuminate\Support\Facades\Auth;
use Carbon\Carbon;

class AgencyMemberExport implements FromCollection, WithHeadings, ShouldAutoSize, WithMapping
{
    protected $request;

    public function __construct($request)
    {
        $this->request = $request;
    }

    public function collection()
    {
        $records = Member::where('member_referred_id', Auth::guard('member')->user()->id);
        if (!empty($this->request->start_date) && !empty($this->request->end_date)) {
            $start = Carbon::createFromFormat('m/Y', $this->request->start_date)->startOfMonth();
            $end   = Carbon::createFromFormat('m/Y', $this->request->end_date)->endOfMonth();

            $records->whereBetween('created_at', [$start, $end]);
        }
        return $records->get();
    }

    public function headings(): array
    {
        return ['SL No', 'Date','Business Name','City','Email','Balance','Note'];
    }

    public function map($value): array
    {
        $credit = Ledger::where('status','Approve')->where('member_id', $value->id)->sum('credit');
        $debit = Ledger::where('status','Approve')->where('member_id', $value->id)->sum('debit');
        $balance = $credit - $debit;
        return [
                $value->id,
                $value->created_at?date('d-m-Y', strtotime($value->created_at)):'-',
                $value->businessName??'-',
                $value->city->name??'-',
                $value->email??'-',
                $balance,
                $value->note??'-',
        ];
    }
}